function [] = curatefiles(filerange,dir_tmp,out_tmp)
%Currate files that are in a number series from a directory and copy the
%desired range of files into a curated folder.  Currently handles Tiff and
%their associted .txt and .xml meta data files
%Synatax:   [data] = curatefiles([5 10]);
%Input:     dir_tmp = the directory of interest
%           out_tmp = where the currated directory goes
%           note: if you enter dir_tmp you will need out_tmp
%           filerange = the range of files you want copied over, example:
%               [5 10] = copy file numbered 5 to 10 over.
%Output:    no output at this moment

%where are the files?
if nargin==1
    dir_tmp = uigetdir2('','Directory structure you want to copy');    %get the directory
    out_tmp = uigetdir3('','Where do you want the new currated directory');
end

%lets process the root
dir_root = dir(dir_tmp);  %grab the root
idx = [dir_root.isdir];   %grab all of the isdir numbers - the first two
idx(1:2) = 0;
curr_names = {dir_root.name};   %grab the all of the names in the root
dir_list = curr_names(idx);    %the directory names in root
%make the currated directory
mkdir(out_tmp,'Curated');
out_tmp = repmat([out_tmp,filesep,'Curated',filesep],size(dir_list'));    %replicated the out_put name for appending
out_list = horzcat(cellstr(out_tmp),dir_list');      %now each cell contains the full output directory path
dir_tmp = repmat([dir_tmp filesep],size(dir_list'));    %replicated the directory name for appending
dir_list = cellstr([dir_tmp char(dir_list')]);      %now each cell contains the full directory path

if ~isempty(dir_list)   %if the root only have files, then no need to go further
    while 1     %we are going to dig the for all of the files
        dir_tmp = [];   %clear!
        out_tmp = [];
        dir_end = 0;    %reset
        %level in
        for i = 1:size(dir_list,1)  %for each dir_step down one
            mkdir(out_list{i,1},out_list{i,2});     %copy over this directory
            curr_out = [out_list{i,1} out_list{i,2}];     %current output directory
            curr_dir = dir_list{i};     %current directory
            dir_info = dir(dir_list{i}); %grab the current dir
            idx = [dir_info.isdir];   %grab all of the isdir numbers
            curr_names = {dir_info.name};   %grab the all of the names
            %if there are files move over if they meet criteria
            %grab the filenames
            curr_file = curr_names(~idx);   %filenames
            idx(1:2) = 0;   %toss the first two
            dir_nxt = curr_names(idx);    %the directories
            if ~isempty(curr_file)  %there are files
                %process tif files
                [filenames] = parsefiles(curr_file,filerange,'tif');
                %process txt files
                [file_tmp] = parsefiles(curr_file,filerange,'txt');
                %process xml files
                [file_tmp2] = parsefiles(curr_file,filerange,'xml');
                %all files
                filenames = horzcat(filenames,file_tmp,file_tmp2);
                %now copy these files over
                for k = 1:size(filenames,2)
                    copyfile([curr_dir,filesep,filenames{k}],[curr_out]);
                end
            end
            if isempty(dir_nxt)   %bottom
                dir_end = dir_end+1;    %one path to its conclusion
            else    %not the bottom
                curr_out = repmat([curr_out filesep],size(dir_nxt'));    %replicated the out_put name for appending
                out_tmp = vertcat(out_tmp,horzcat(cellstr(curr_out),dir_nxt'));      %now each cell contains the full output directory path
                curr_dir = repmat([curr_dir filesep],size(dir_nxt'));    %replicated the directory name for appending
                dir_tmp = vertcat(dir_tmp,cellstr([curr_dir char(dir_nxt')]));      %now each cell contains the full directory path
            end
        end
        if dir_end==size(dir_list,1)    %all directories are at an end
            break
        else    %move next level down
            dir_list = dir_tmp;
            out_list = out_tmp;
        end
    end
end
%--------------------------------------------------------------------------
%Parse the files to extract the files to copy over
function [filenames] = parsefiles(curr_file,filerange,filetype)
itr = 1;
filenames = [];
for j = 1:size(curr_file,2);
    if strcmp(curr_file{j}(end-2:end),filetype)    %only deal with files of the selected type
        switch filetype
            case 'tif'
                num_end = strfind(curr_file{j},'tile');
                num_end = num_end-1;   %the '_' before 'tile'
                tmpidx = isstrprop(curr_file{j},'punct');
                tmpidx = find(tmpidx==1);   %the punctuation positions
                num_strt = find(tmpidx==num_end);  % the '_' location
                num_strt = tmpidx(num_strt-1);  %the punct before the '_'
                num_strt = num_strt+1;  %now the actual number start
                num_end = num_end-1;    %now the actual number end
                numstr = curr_file{j}(num_strt:num_end);     %grab the number string
            case 'txt'
                num_end = strfind(curr_file{j},'metadata');
                num_end = num_end-1;   %the '_' before 'tile'
                tmpidx = isstrprop(curr_file{j},'punct');
                tmpidx = find(tmpidx==1);   %the punctuation positions
                num_strt = find(tmpidx==num_end);  % the '_' location
                num_strt = tmpidx(num_strt-1);  %the punct before the '_'
                num_strt = num_strt+1;  %now the actual number start
                num_end = num_end-1;    %now the actual number end
                numstr = curr_file{j}(num_strt:num_end);     %grab the number string
            otherwise   %just grab all of the numbers in the file
                tmpidx = isstrprop(curr_file{j},'digit');
                numstr = curr_file{j}(tmpidx);
        end
        num = str2num(numstr);  %convert to number
        if num>=filerange(1) && num<=filerange(2)
            filenames{itr} = curr_file{j};
            itr = itr+1;
        end
    end
end